<?php
  $ruta="../";
  include_once($ruta."class/vusuario2.php");
  $vusuario2=new vusuario2;
  include_once($ruta."class/desembolso.php");
  $desembolso=new desembolso;
  include_once($ruta."class/persona.php");
  $persona=new persona;
  include_once($ruta."class/vadmejecutivo.php");
  $vadmejecutivo=new vadmejecutivo;
  include_once($ruta."funciones/funciones.php");
  session_start(); 
  $fechaHoy=date('Y-m-d'); 
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <?php
      $hd_titulo="Lista de Programación de desembolso";
      include_once($ruta."includes/head_basico.php");
      include_once($ruta."includes/head_tabla.php");
      include_once($ruta."includes/head_tablax.php");
    ?>
</head>
<body>
    <?php
      include_once($ruta."head.php");
    ?>
    <div id="main">
      <div class="wrapper">
        <?php
          $idmenu=1095;
          include_once($ruta."aside.php");
        ?>
        <section id="content">
          <!--breadcrumbs start-->
          <div id="breadcrumbs-wrapper">
            <div class="container">
              <div class="row">
                <div class="col s12 m12 l12">
                  <h5 class="breadcrumbs-title"><i class="fa fa-tag"></i> <?php echo $hd_titulo; ?></h5>
                </div>
              </div>
            </div>
          </div>
     
          <div class="container">
            <div class="section">
              <div class="row">
                <a href="#modal1" class="btn waves-effect waves-light indigo modal-trigger"><i class="fa fa-plus-square"></i> NUEVO NUEVO REGISTRO</a><br><br>

                <table id="example2" class="display" cellspacing="0" width="100%">
                  <thead>
                    <tr>
                      <th>ID</th>
                      <th>Descripción</th>
                      <th>Fecha </th> 
                      <th>Monto (Bs)</th>
                      <th>Asesor</th>
                      <th>Acciones</th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                      <th>ID</th>
                      <th>Descripción</th>
                      <th>Tipo gasto </th> 
                      <th>Fecha </th> 
                      <th>Monto (Bs)</th>
                      <th>Asesor</th>
                      <th>Acciones</th>
                    </tr>
                  </tfoot>
                  <tbody>
                    <?php
                    foreach($gastogeneral->mostrarTodo("estado=1") as $f)
                    {
                      $vus=$vusuario2->muestra($f['usuarioasesor']);
                       $perAsesor=$persona->muestra($vus['idpersona']);
                       $dom=$dominio->muestra($f['iddominio']);
                      
                      
                    ?>
                    <tr style="<?php echo $estilo ?>">
                      <td><?php echo $f['idgastogeneral'] ?></td>
                      <td><?php echo $f['descripcion'] ?></td>
                      <td><?php echo $dom['nombre'] ?></td> 
                      <td><?php echo $f['nrorecibo'] ?></td>                      
                      <td><?php echo $f['fecha'] ?></td>
                      <td><?php echo $f['monto'] ?></td>
                      <td><?php echo $perAsesor['nombre'] ?></td>
                      <td>
                          <button onclick="cambiaestado('<?php echo $f['idpasaje'] ?>','0');" class="btn-jh red"><i class="fa fa-times-circle"></i> Eliminar</button>
                      </td>
                    </tr>
                    <?php
                      }
                    ?>
                  </tbody>
                </table>
              </div>
            </div>     
            </div>
            
            <div class="container">
            <div class="section">
              <div class="row">
                    <div id="modal1" class="modal">
                  <div class="modal-content">
                  <h1>NUEVO DESEMBOLSO</h1>
                    <form class="col s12" id="idform" action="return false" onsubmit="return false" method="POST">
                      <div class="row">
                        <div class="input-field col s12 m6 l6">
                         <label>Tipo de Gastos</label>
                          <select id="idtipogasto" name="idtipogasto">
                            <option disabled value="">Seleccionar</option>
                            <?php
                              foreach($dominio->mostrarTodo("tipo='TIPOGASTO'") as $f)
                              {
                                ?>
                                  <option value="<?php echo $f['short']; ?>"><?php echo $f['nombre']; ?></option>
                                <?php
                              }
                            ?>
                          </select>
                        </div>
                        <div class="input-field col s12 m12 l12">
                          <input id="iddescripcion" name="iddescripcion"  type="text" class="validate">
                          <label for="iddescripcion">Descripción</label>
                        </div> 
                        <div class="input-field col s12 m6 l6">
                          <input id="idnrorecibo" name="idnrorecibo" type="text" value="0" class="validate">
                          <label for="idnrorecibo">Nro. Recibo</label>
                        </div>
                        <div class="input-field col s12 m6 l6">
                          <input id="idfecha" name="idfecha" type="date" class="validate">
                          <label for="idfecha">Fecha desembolso</label>
                        </div>
                        <div class="input-field col s12 m6 l6">
                          <input id="idmonto" name="idmonto" type="number" class="validate">
                          <label for="idmonto">Monto</label>
                        </div>
                        
                        <div class="input-field col s12 m6 l6">
                          <label>Asesor</label>
                          <select id="iduserasesor" name="iduserasesor">
                            <option value="0">Seleccionar Asesor</option>
                            <?php
                              foreach($vadmejecutivo->mostrarTodo("idtipo=142") as $ej)
                              {
                                $vus=$vusuario2->mostrarUltimo("idpersona=".$ej['idpersona']);
                                
                                ?>
                                  <option value="<?php echo $vus['idvusuario2']; ?>"><?php echo $ej['nombre'].' '.$ej['paterno']; ?></option>
                                <?php
                              }
                            ?>
                          </select>
                        </div>
                        
                      </div>
                    </form>
                  </div><br><br><br><br><br><br><br><br>
<br><br>

                  <div class="modal-footer">
                    <a href="#" class="btn waves-effect waves-light red modal-action modal-close"><i class="fa fa-times"></i> CANCELAR</a>
                    <button id="btnSave" href="#" class="btn waves-effect waves-light green"><i class="fa fa-save"></i> PROGRAMAR</button>

                  </div>
                </div>
                </div>
            </div>     
            </div>


        </section>
      </div>
    </div>
    <div id="idresultado"></div>
    <!-- end -->
    <!-- jQuery Library -->
    <?php
      include_once($ruta."includes/script_basico.php");
      include_once($ruta."includes/script_tabla.php");
      include_once($ruta."includes/script_tablax.php");
    ?>
    <script type="text/javascript">
    $(document).ready(function() {
      $('#example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
      });
        $('#example1').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
      });
          $('#example2').DataTable( {
        dom: 'Bfrtip',
        "order": [[ 2, "asc" ]],
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
      });
    });
 $("#btnSave").click(function(){
        //$('#btnSave').attr("disabled",true);
        if (validar()) 
        {          
                swal({
                  title: "¿Esta seguro?",
                  text: "Programar",
                  type: "warning",
                  showCancelButton: true,
                  confirmButtonColor: "#2c2a6c",
                  confirmButtonText: "CONFIRMAR",
                  closeOnConfirm: false,
                  showLoaderOnConfirm: true,
                }, function () {
                  var str = $( "#idform" ).serialize();
                  $.ajax({
                    url: "guardar.php",
                    type: "POST",
                    data: str,
                    success: function(resp){
                      setTimeout(function(){     
                        console.log(resp);
                        $('#idresultado').html(resp);  
                      }, 10); 
                    }
                  }); 
                });
        }else{
          swal("ERROR","Faltan datos","error");
        }
      });
function validar(){
        retorno=true;
        nombre=$('#idnombre').val();
        mon=$('#idmonto').val();
        fec=$('#idfecha').val();
        hor=$('#idhora').val();
        if(nombre=="" || mon=="0" || fec=="" || hor==""){
          retorno=false;
        }
        return retorno;
      }    
     function cambiaestado(id,estado){
      swal({
        title: "Estas Seguro?",
        text: "Ejecutar operación",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#28e29e",
        confirmButtonText: "Estoy Seguro",
        closeOnConfirm: false
      }, function () {      
        $.ajax({
          url: "cambioestado.php",
          type: "POST",
          data: "id="+id+"&estado="+estado,
          success: function(resp){
            setTimeout(function(){     
              console.log(resp);
              $('#idresultado').html(resp);  
            }, 10);
          }   
        });
      }); 
    }
    </script>
</body>

</html>