<?php
  $ruta="../";
  include_once($ruta."class/dominio.php");
  $dominio=new dominio;
  include_once($ruta."class/vadmejecutivo.php");
  $vadmejecutivo=new vadmejecutivo;
  include_once($ruta."class/ingresoglobal.php");
  $ingresoglobal=new ingresoglobal;
  include_once($ruta."class/ciclo.php");
  $ciclo=new ciclo;
  include_once($ruta."class/persona.php");
  $persona=new persona;
  include_once($ruta."class/recuperacionmov.php");
  $recuperacionmov=new recuperacionmov;
  include_once($ruta."funciones/funciones.php");
  session_start();  
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <?php
      $hd_titulo="Ingreso general de cobros Global";
      include_once($ruta."includes/head_basico.php");
      include_once($ruta."includes/head_tabla.php");
      include_once($ruta."includes/head_tablax.php");
    ?>
</head>
<body>
    <?php
      include_once($ruta."head.php");
    ?>
    <div id="main">
      <div class="wrapper">
        <?php
          $idmenu=1092;
          include_once($ruta."aside.php");
        ?>
        <section id="content">
          <!--breadcrumbs start-->
          <div id="breadcrumbs-wrapper">
            <div class="container">
                <div class="row " style="background: #555555; text-align: center; color:white; font-size: 25px; border-radius: 5px;">
                    <?php echo $hd_titulo; ?>
                    <button class="btn-jh waves-effect waves-light darken-4 green" onclick="cargapoopup();"><i class="fa fa-plus-square"></i> NUEVO</button>
            </div>
               
     
          <div class="container">
            <div class="section">
              <div class="row" >
                <div class="col s12 m12 l12" style="border-radius: 5px; border: 1px solid #E8E8E8; background: white;">
                <table id="example2" class="display" cellspacing="0" width="100%">
                  <thead>
                    <tr>
                      <th>Cod</th>
                      <th>Detalle</th> 
                      <th>Fecha</th>
                      <th>Asesor</th> 
                      <th style="text-align: right;">Monto</th>
                      <th style="text-align: right;">Acciones</th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                      <th>Cod</th>
                      <th>Detalle</th> 
                      <th>Fecha</th>
                      <th>Asesor</th> 
                      <th style="text-align: right;">Monto</th>
                      <th style="text-align: right;">Acciones</th>
                    </tr>
                  </tfoot>
                  <tbody>
                    <?php
                    foreach($ingresoglobal->mostrarTodo("estado=1") as $f)
                    {

                       $eje=$vadmejecutivo->muestra($f['idadmejecutivo']);
                      $lblcode=ecUrl($f['idingresoglobal']);
                      //$per=$persona->muestra($f['idpersona']);
                      $fechaactual=date('Y-m-d');
                      $mesactual = date('m', strtotime($fechaactual));
                      $mesregistro = date('m', strtotime($f['fecha']));

                      if ($mesactual==$mesregistro) 
                      {
                        $estilo="background-color: #EAFAF1;";
                      }else{
                        $estilo="background-color: ";
                      }
                    ?>
                    <tr style="<?php echo $estilo ?>">
                      <td><?php echo $f['idingresoglobal'] ?></td>
                      <td><?php echo $f['detalle'] ?></td>
                      <td><?php echo $f['fecha'] ?></td>
                      <td><?php echo $eje['
                      '] ?></td>
                      <td style="text-align: right;"><?php echo number_format($f['monto'], 2, '.', '') ?></td>
                      <td  style="text-align: right;">                                             
                        <a href="#" class="btn-jh waves-effect darken-4 orange"><i class="fa fa-print"></i></a>
                      </td>
                    </tr>
                    <?php
                      }
                    ?>
                  </tbody>
                </table>
              </div>
            </div>
            </div>     
            </div>

          </div>
           <div class="container">
            <div class="section"> 
            <div class="row" >          
                <div id="modal2" class="modal">
                  <div class="modal-content">
                   <form class="col s12" id="idform" action="return false" onsubmit="return false" method="POST">
                  <fieldset class="informacion" style="background: #D1D1D1;">
                    <legend><div class="titulo">
                      <strong>REGISTRAR COBRO</strong> </div></legend>
                    <div class="col s12 m12 l12"  style="background: white;">
                      <div class="input-field col s12 m6 l6" >
                          <input id="idnrorecibo" name="idnrorecibo" type="number" value="0" class="validate">
                          <label for="idnrorecibo">Nro. recibo</label>
                        </div>
                      <div class="input-field col s12 m6 l6" >
                          <input id="idmonto" name="idmonto" type="number" value="0.00" class="validate">
                          <label for="idmonto">Monto a cobrar</label>
                        </div>
                        <div class="input-field col s12 m6 l6" >
                          <input id="idfecha" name="idfecha" type="date" value="<?php echo date('Y-m-d') ?>" class="validate">
                          <label for="idfecha">Fecha Registro</label>
                        </div>
                        <div class="input-field col s12 m6 l6">
                          <label>Asesor</label>
                          <select id="idadmejecutivo" name="idadmejecutivo">
                            <option value="0">Pro-ayuda</option>
                            <?php
                              foreach($vadmejecutivo->mostrarTodo("idtipo=142") as $ej)
                              {
                                ?>
                                  <option value="<?php echo $ej['idvadmejecutivo']; ?>"><?php echo $ej['nombre'].' '.$ej['paterno']; ?></option>
                                <?php
                              }
                            ?>
                          </select>
                        </div>
                        <div class="input-field col s12 m12 l12">
                          <input id="iddescripcion" name="iddescripcion" value="COBRADO" type="text">
                        <label for="iddescripcion">Descripción</label>                        
                       </div> 
                    </div>                      
                  </fieldset>
                </form>
                  </div>
                  <div class="modal-footer">
                   <!-- <a id="btnLimpiar" onclick="limpiar();" class="btn waves-effect waves-light red"><i class="fa fa-clear"></i> Limpiar</a> -->
                         <a id="btnSave" class="btn waves-effect waves-light " style="background: #555555;"><i class="fa fa-save"></i> REGISTRAR COBRO</a> 
                  </div>
                </div>
                </div>
            </div>
          </div>
          <?php
            include_once("../footer.php");
          ?>
        </section>
      </div>
    </div>
    <div id="idresultado"></div>
    <!-- end -->
    <!-- jQuery Library -->
    <?php
      include_once($ruta."includes/script_basico.php");
      include_once($ruta."includes/script_tabla.php");
      include_once($ruta."includes/script_tablax.php");
    ?>
    <script type="text/javascript">
    $(document).ready(function() {
      $('#example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
      });
        $('#example1').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
      });
          $('#example2').DataTable( {
        dom: 'Bfrtip',
        "order": [[ 0, "desc" ]],
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
      });
    });
    function cargapoopup()
  {
    $('#modal2').openModal();
  } 
  $("#btnSave").click(function(){
        $('#btnSave').attr("disabled",true);        
        if (validar()) 
        {          
                swal({
                  title: "¿Esta seguro?",
                  text: "Realizar registro de ingreso",
                  type: "warning",
                  showCancelButton: true,
                  confirmButtonColor: "#2c2a6c",
                  confirmButtonText: "Registrar",
                  closeOnConfirm: false,
                  showLoaderOnConfirm: true
                }, function () {
                  var str = $( "#idform" ).serialize();
                  $.ajax({
                    url: "nuevo/guardar.php",
                    type: "POST",
                    data: str,
                    success: function(resp){
                      setTimeout(function(){     
                        console.log(resp);
                        $('#idresultado').html(resp);  
                      }, 1500);
                    }
                  }); 
                });
        }else{
          swal("ERROR","Faltan datos","error");
        }
      });
  function validar(){
        retorno=true;
        monto=$('#idmonto').val();
        if(monto<="0"){
          retorno=false;
        }
        return retorno;
      }
    function cambiaestado(id,estado){
      swal({
        title: "Estas Seguro?",
        text: "Cambiaras el estado al ejecutivo",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#28e29e",
        confirmButtonText: "Estoy Seguro",
        closeOnConfirm: false
      }, function () {      
        $.ajax({
          url: "cambiaestado.php",
          type: "POST",
          data: "id="+id+"&estado="+estado,
          success: function(resp){
            console.log(resp);
            $("#idresultado").html(resp);
          }   
        });
      }); 
    }
    </script>
</body>

</html>