<?php
  $ruta="../../../";
  include_once($ruta."class/dominio.php");
  $dominio=new dominio;
  include_once($ruta."class/vadmejecutivo.php");
  $vadmejecutivo=new vadmejecutivo;
  include_once($ruta."class/grupo.php");
  $grupo=new grupo;
  include_once($ruta."class/ciclo.php");
  $ciclo=new ciclo;
   include_once($ruta."class/grupocredito.php");
  $grupocredito=new grupocredito;
  include_once($ruta."class/tipobanca.php");
  $tipobanca=new tipobanca;
  include_once($ruta."class/personagrupo.php");
  $personagrupo=new personagrupo;
  include_once($ruta."class/persona.php");
  $persona=new persona;
  include_once($ruta."class/credito.php");
  $credito=new credito;

  include_once($ruta."funciones/funciones.php");
  session_start(); 
  extract($_GET);
  $idgrupo=dcUrl($lblcode);
  $gr=$grupo->muestra($idgrupo); 
  $ci=$ciclo->muestra($gr['idciclo']);
  $eje=$vadmejecutivo->muestra($gr['idadmejecutivo']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <?php
      $hd_titulo="Creditos del grupo";
      include_once($ruta."includes/head_basico.php");
      include_once($ruta."includes/head_tabla.php");
      include_once($ruta."includes/head_tablax.php");
    ?>

    <style type="text/css">   

.tb{
  font-weight: bold;
  color: #268E6A;
}
</style>
</head>
<body>
    <?php
      include_once($ruta."head.php");
    ?>
    <div id="main">
      <div class="wrapper">
        <?php
          $idmenu=1042;
          include_once($ruta."aside.php");
        ?>
        <section id="content">
          <!--breadcrumbs start-->
          <div id="breadcrumbs-wrapper">
            <div class="container">
              <div class="row">
               <div class="col s12 m12 l12">
                  <h5 class="breadcrumbs-title"><i class="fa fa-tag"></i> ADMINISTRAR GRUPO <?php echo $gr['nombre'] ?></h5>
                  <a href="../?lblcode=<?php echo $lblcode ?>" class="btn waves-effect waves-light blue lighten-1"><i class="fa fa-mail-reply-all"></i> Volver</a>
                </div>
              </div>
            </div>
          </div>
          <div class="container">
            <div class="section">
              <div class="row">
                <div class='col s12 m12 l12'>                   
                  <fieldset class="informacion">
                    <legend><div class="titulo"><strong>Información del Grupo</strong> </div></legend>
                      <div class="col s12 m12 l6">Grupo: <b><?php echo $gr['nombre'] ?></b></div>
                      <div class="col s12 m12 l6">Ciclo: <b><?php echo $ci['nombre'] ?></b></div>
                      <div class="col s12 m12 l6">Asesor: <b><?php echo $eje['nombre'].' '.$eje['paterno'] ?></b></div>
                      <div class="col s12 m12 l6">Hora de reunión: <b><?php echo $gr['horareunion'] ?></b></div>
                      <div class="col s12 m12 l6">Lugar reunión: <b><?php echo $gr['lugarreunion'] ?></b></div>
                  </fieldset>
                </div> 
              </div>
            </div> 
          </div>        
          <div class="container">
            <div class="section">
              <div class="row">
                <div class="col s12">
                  <div class="red alert btn">
                    No puede eliminar creditos que ya hayan pagado una o más de una cuotas.
                  </div>
                  <fieldset class="informacion">
                      <legend><div class="titulo"><strong>Créditos del grupo</strong> </div></legend>
                      <div class="col s12 m12 l12">
                        <table id="example2" class="display" cellspacing="0" width="100%">
                          <thead>
                            <tr>
                               <th>Cod</th>
                              <th>Frecuancia de pago</th> 
                              <th>Nro de cuotas</th>
                              <th>Fecha de desembolso</th>
                              <th>Fecha 1er pago</th>
                              <th>Fecha cierre</th>
                              <th>Estado</th>
                              <th>Acciones</th>
                              <th>Estado Credito</th>
                            </tr>
                          </thead>
                          <tbody>
                            <?php
                            foreach($grupocredito->mostrarTodo("idgrupo=".$idgrupo) as $f)
                            {
                              $lblcod=ecUrl($f['idgrupocredito']);
                              $cred=$credito->mostrarPrimero("idgrupocredito=".$f['idgrupocredito']." and tipocredito=0");
                              $code=$cred['idcredito'];
                              //0 Pendiente
                              //1 Vigente
                              //2 Completado
                              $estado="";
                              switch ($f['estado']) {
                                case '0':
                                  $estilo="background-color: #FADBD8;";
                                  $estado="PENDIENTE";
                                break;
                                case '1':
                                  $estilo="background-color: #A4F3C6;";
                                  $estado="ACTIVO";
                                break;
                                break;
                                case '2':
                                  $estilo="background-color: #E1FBFF;";
                                  $estado="COMPLETADO";
                                break;
                              }
                              $dom=$dominio->muestra($f['frecuenciapago']);
                            ?>
                            <tr style="<?php echo $estilo ?>">
                            <td><?php echo $f['idgrupocredito'] ?></td>
                              <td><?php echo $dom['nombre'] ?></td>
                              <td><?php echo $f['nrocuotas'] ?></td>
                              <td><?php echo $f['fechadesembolso'] ?></td>
                              <td><?php echo $f['fecha1erpago'] ?></td>    
                              <td><?php echo $f['fechacierre'] ?></td>

                              <td><?php echo $estado ?></td>

                              <td>
                                <?php
                                  if ($f['cuota']==0) {
                                    ?>
                                      <button onclick="EliminarCredito('<?php echo $f['idgrupocredito'] ?>')" class="btn-jh red darken-3"><i class="fa fa-trash"></i> ELIMINAR CRÉDITO</button>
                                    <?php
                                  }
                                ?>
                              </td>
                              <td><?php echo devuelveEstado($f['estadocredito']) ?></td>              
                            </tr>
                            <?php
                              }
                            ?>
                          </tbody>
                        </table>
                      </div> 
                    </fieldset>
                </div>
              </div> 
            </div>
          </div>
        </section>
      </div>
    </div>
    <div id="idresultado"></div>
    <!-- end -->
    <!-- jQuery Library -->
    <?php
      include_once($ruta."includes/script_basico.php");
      include_once($ruta."includes/script_tabla.php");
      include_once($ruta."includes/script_tablax.php");
    ?>
    <script type="text/javascript">
      function EliminarCredito(idgrupocred){
        swal({
          title: "¿Esta seguro?",
          text: "Se quitará la persona del grupo",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#2c2a6c",
          confirmButtonText: "Eliminar",
          closeOnConfirm: false,
          showLoaderOnConfirm: true
        }, function () {
          $.ajax({
            url: "eliminar.php",
            type: "POST",
            data: "idgcred="+idgrupocred,
            success: function(resp){
              setTimeout(function(){     
                console.log(resp);
                $('#idresultado').html(resp);  
              }, 100); 
            }
          }); 
        });
      }
    $(document).ready(function() {
      $('#example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
      });
        $('#example1').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
      });
          $('#example2').DataTable( {
        dom: 'Bfrtip',
        "order": [[ 0, "desc" ]],
        buttons: [
            
        ]
      });
           $('#example3').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            
        ]
      });
    });
    
   
    </script>
</body>

</html>