<?php
  $ruta="../";
  include_once($ruta."class/dominio.php");
  $dominio=new dominio;
  include_once($ruta."class/vadmejecutivo.php");
  $vadmejecutivo=new vadmejecutivo;
  include_once($ruta."class/recuperacion.php");
  $recuperacion=new recuperacion;
  include_once($ruta."class/ciclo.php");
  $ciclo=new ciclo;
  include_once($ruta."class/persona.php");
  $persona=new persona;
  include_once($ruta."class/recuperacionmov.php");
  $recuperacionmov=new recuperacionmov;
  include_once($ruta."funciones/funciones.php");
  session_start();  
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <?php
      $hd_titulo="Lista de deudas a recuperar ( sin plan de pagos)";
      include_once($ruta."includes/head_basico.php");
      include_once($ruta."includes/head_tabla.php");
      include_once($ruta."includes/head_tablax.php");
    ?>
</head>
<body>
    <?php
      include_once($ruta."head.php");
    ?>
    <div id="main">
      <div class="wrapper">
        <?php
          $idmenu=1090;
          include_once($ruta."aside.php");
        ?>
        <section id="content">
          <!--breadcrumbs start-->
          <div id="breadcrumbs-wrapper">
            <div class="container">
                <div class="row " style="background: #555555; text-align: center; color:white; font-size: 25px; border-radius: 5px;">
                    <?php echo $hd_titulo; ?>
                    <a href="nuevo/" class="btn-jh waves-effect waves-light darken-4 green"><i class="fa fa-plus-square"></i> NUEVO</a>
            </div>
               
     
          <div class="container">
            <div class="section">
              <div class="row" >
                <div class="col s12 m12 l12" style="border-radius: 5px; border: 1px solid #E8E8E8; background: white;">
                <table id="example2" class="display" cellspacing="0" width="100%">
                  <thead>
                    <tr>
                      <th>Cod</th>
                      <th>Carnet</th> 
                      <th>Cliente</th> 
                      <th>Origen</th>
                      <th>Monto</th>
                      <th>Saldo</th>
                      <th>Asesor</th>
                      <th>Acciones</th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                       <th>Cod</th>
                      <th>Carnet</th> 
                      <th>Cliente</th> 
                      <th>Origen</th>
                      <th>Monto</th>
                      <th>Saldo</th>
                      <th>Asesor</th>
                      <th>Acciones</th>
                    </tr>
                  </tfoot>
                  <tbody>
                    <?php
                    foreach($recuperacion->mostrarTodo("estado=0") as $f)
                    {

                       $eje=$vadmejecutivo->muestra($f['idadmejecutivo']);
                      $lblcode=ecUrl($f['idrecuperacion']);
                      $per=$persona->muestra($f['idpersona']);

                       $total=0;
                        foreach($recuperacionmov->mostrarTodo("idrecuperacion=".$f['idrecuperacion']) as $remov)
                        {
                            $total=$total+number_format($remov['monto'], 2, '.', '');
                        }
                        $saldo=$f['monto'] - $total;
                      if (number_format($saldo, 2, '.', '')>0) 
                      {
                        $estilo="background-color: #FDEDEC;";
                      }else{
                        $estilo="background-color: #EAFAF1;";
                      }
                    ?>
                    <tr style="<?php echo $estilo ?>">
                      <td><?php echo $f['idrecuperacion'] ?></td>
                      <td><?php echo $per['carnet'].' '.$per['expedido'] ?></td>
                      <td><?php echo $per['nombre'].' '.$per['paterno'].' '.$per['materno'] ?></td>
                      <td><?php echo $f['origen'] ?></td>
                      <td><?php echo number_format($f['monto'], 2, '.', '') ?></td>
                      <td><?php echo number_format($saldo, 2, '.', '') ?></td>
                      <td><?php echo $eje['nombre'].' '.$eje['paterno'] ?></td>
                      <td>
                         <?php
                          if (number_format($saldo, 2, '.', '')>0) 
                          {
                            ?>
                               <a href="cobrar/?lblcode=<?php echo $lblcode ?>" class="btn-jh waves-effect darken-4 blue"><i class="fa fa-money"></i> COBRAR</a>  
                          <?php
                          }else{
                            ?>
                              <a href="cobrar/?lblcode=<?php echo $lblcode ?>" class="btn-jh waves-effect darken-4 cyan"><i class="fa fa-money"></i> VER (Cancelado)</a> 
                          <?php
                          }
                         ?>
                                              
                        <a href="#" class="btn-jh waves-effect darken-4 orange"><i class="fa fa-print"></i></a>
                      </td>
                    </tr>
                    <?php
                      }
                    ?>
                  </tbody>
                </table>
              </div>
            </div>
            </div>     
            </div>

          </div>
          <?php
            include_once("../footer.php");
          ?>
        </section>
      </div>
    </div>
    <div id="idresultado"></div>
    <!-- end -->
    <!-- jQuery Library -->
    <?php
      include_once($ruta."includes/script_basico.php");
      include_once($ruta."includes/script_tabla.php");
      include_once($ruta."includes/script_tablax.php");
    ?>
    <script type="text/javascript">
    $(document).ready(function() {
      $('#example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
      });
        $('#example1').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
      });
          $('#example2').DataTable( {
        dom: 'Bfrtip',
        "order": [[ 0, "desc" ]],
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
      });
    });
    function cambiaestado(id,estado){
      swal({
        title: "Estas Seguro?",
        text: "Cambiaras el estado al ejecutivo",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#28e29e",
        confirmButtonText: "Estoy Seguro",
        closeOnConfirm: false
      }, function () {      
        $.ajax({
          url: "cambiaestado.php",
          type: "POST",
          data: "id="+id+"&estado="+estado,
          success: function(resp){
            console.log(resp);
            $("#idresultado").html(resp);
          }   
        });
      }); 
    }
    </script>
</body>

</html>